package io.burkard.cdk.services.s3

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object IntelligentTieringConfiguration {

  def apply(
    name: String,
    prefix: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.services.s3.Tag]] = None,
    deepArchiveAccessTierTime: Option[software.amazon.awscdk.Duration] = None,
    archiveAccessTierTime: Option[software.amazon.awscdk.Duration] = None
  ): software.amazon.awscdk.services.s3.IntelligentTieringConfiguration =
    (new software.amazon.awscdk.services.s3.IntelligentTieringConfiguration.Builder)
      .name(name)
      .prefix(prefix.orNull)
      .tags(tags.map(_.asJava).orNull)
      .deepArchiveAccessTierTime(deepArchiveAccessTierTime.orNull)
      .archiveAccessTierTime(archiveAccessTierTime.orNull)
      .build()
}
