package io.burkard.cdk.services.rds

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CredentialsBaseOptions {

  def apply(
    excludeCharacters: Option[String] = None,
    encryptionKey: Option[software.amazon.awscdk.services.kms.IKey] = None,
    secretName: Option[String] = None,
    replicaRegions: Option[List[_ <: software.amazon.awscdk.services.secretsmanager.ReplicaRegion]] = None
  ): software.amazon.awscdk.services.rds.CredentialsBaseOptions =
    (new software.amazon.awscdk.services.rds.CredentialsBaseOptions.Builder)
      .excludeCharacters(excludeCharacters.orNull)
      .encryptionKey(encryptionKey.orNull)
      .secretName(secretName.orNull)
      .replicaRegions(replicaRegions.map(_.asJava).orNull)
      .build()
}
