package io.burkard.cdk.services.pinpoint

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnBaiduChannel {

  def apply(
    internalResourceId: String,
    secretKey: String,
    apiKey: String,
    applicationId: String,
    enabled: Option[Boolean] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.pinpoint.CfnBaiduChannel =
    software.amazon.awscdk.services.pinpoint.CfnBaiduChannel.Builder
      .create(stackCtx, internalResourceId)
      .secretKey(secretKey)
      .apiKey(apiKey)
      .applicationId(applicationId)
      .enabled(enabled.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
