package io.burkard.cdk.services.lex.cfnBot

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object FulfillmentUpdateResponseSpecificationProperty {

  def apply(
    frequencyInSeconds: Number,
    messageGroups: List[_],
    allowInterrupt: Option[Boolean] = None
  ): software.amazon.awscdk.services.lex.CfnBot.FulfillmentUpdateResponseSpecificationProperty =
    (new software.amazon.awscdk.services.lex.CfnBot.FulfillmentUpdateResponseSpecificationProperty.Builder)
      .frequencyInSeconds(frequencyInSeconds)
      .messageGroups(messageGroups.asJava)
      .allowInterrupt(allowInterrupt.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
