package io.burkard.cdk.services.iam

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnOIDCProviderProps {

  def apply(
    thumbprintList: List[String],
    url: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    clientIdList: Option[List[String]] = None
  ): software.amazon.awscdk.services.iam.CfnOIDCProviderProps =
    (new software.amazon.awscdk.services.iam.CfnOIDCProviderProps.Builder)
      .thumbprintList(thumbprintList.asJava)
      .url(url.orNull)
      .tags(tags.map(_.asJava).orNull)
      .clientIdList(clientIdList.map(_.asJava).orNull)
      .build()
}
