package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnTransitGatewayRoute {

  def apply(
    internalResourceId: String,
    transitGatewayRouteTableId: String,
    blackhole: Option[Boolean] = None,
    destinationCidrBlock: Option[String] = None,
    transitGatewayAttachmentId: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ec2.CfnTransitGatewayRoute =
    software.amazon.awscdk.services.ec2.CfnTransitGatewayRoute.Builder
      .create(stackCtx, internalResourceId)
      .transitGatewayRouteTableId(transitGatewayRouteTableId)
      .blackhole(blackhole.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .destinationCidrBlock(destinationCidrBlock.orNull)
      .transitGatewayAttachmentId(transitGatewayAttachmentId.orNull)
      .build()
}
