package io.burkard.cdk.services.cognito

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object UserInvitationConfig {

  def apply(
    smsMessage: Option[String] = None,
    emailSubject: Option[String] = None,
    emailBody: Option[String] = None
  ): software.amazon.awscdk.services.cognito.UserInvitationConfig =
    (new software.amazon.awscdk.services.cognito.UserInvitationConfig.Builder)
      .smsMessage(smsMessage.orNull)
      .emailSubject(emailSubject.orNull)
      .emailBody(emailBody.orNull)
      .build()
}
