package io.burkard.cdk.services.codedeploy

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AutoRollbackConfig {

  def apply(
    deploymentInAlarm: Option[Boolean] = None,
    failedDeployment: Option[Boolean] = None,
    stoppedDeployment: Option[Boolean] = None
  ): software.amazon.awscdk.services.codedeploy.AutoRollbackConfig =
    (new software.amazon.awscdk.services.codedeploy.AutoRollbackConfig.Builder)
      .deploymentInAlarm(deploymentInAlarm.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .failedDeployment(failedDeployment.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .stoppedDeployment(stoppedDeployment.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
