package io.burkard.cdk.services.certificatemanager

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CertificateProps {

  def apply(
    domainName: String,
    validation: Option[software.amazon.awscdk.services.certificatemanager.CertificateValidation] = None,
    subjectAlternativeNames: Option[List[String]] = None
  ): software.amazon.awscdk.services.certificatemanager.CertificateProps =
    (new software.amazon.awscdk.services.certificatemanager.CertificateProps.Builder)
      .domainName(domainName)
      .validation(validation.orNull)
      .subjectAlternativeNames(subjectAlternativeNames.map(_.asJava).orNull)
      .build()
}
