package io.burkard.cdk.services.budgets

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnBudgetsActionProps {

  def apply(
    budgetName: String,
    subscribers: List[_],
    actionThreshold: software.amazon.awscdk.services.budgets.CfnBudgetsAction.ActionThresholdProperty,
    actionType: String,
    notificationType: String,
    executionRoleArn: String,
    definition: software.amazon.awscdk.services.budgets.CfnBudgetsAction.DefinitionProperty,
    approvalModel: Option[String] = None
  ): software.amazon.awscdk.services.budgets.CfnBudgetsActionProps =
    (new software.amazon.awscdk.services.budgets.CfnBudgetsActionProps.Builder)
      .budgetName(budgetName)
      .subscribers(subscribers.asJava)
      .actionThreshold(actionThreshold)
      .actionType(actionType)
      .notificationType(notificationType)
      .executionRoleArn(executionRoleArn)
      .definition(definition)
      .approvalModel(approvalModel.orNull)
      .build()
}
