package io.burkard.cdk.services.autoscaling

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnWarmPoolProps {

  def apply(
    autoScalingGroupName: String,
    poolState: Option[String] = None,
    maxGroupPreparedCapacity: Option[Number] = None,
    minSize: Option[Number] = None
  ): software.amazon.awscdk.services.autoscaling.CfnWarmPoolProps =
    (new software.amazon.awscdk.services.autoscaling.CfnWarmPoolProps.Builder)
      .autoScalingGroupName(autoScalingGroupName)
      .poolState(poolState.orNull)
      .maxGroupPreparedCapacity(maxGroupPreparedCapacity.orNull)
      .minSize(minSize.orNull)
      .build()
}
