package io.burkard.cdk.services.autoscaling

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnWarmPool {

  def apply(
    internalResourceId: String,
    autoScalingGroupName: String,
    poolState: Option[String] = None,
    maxGroupPreparedCapacity: Option[Number] = None,
    minSize: Option[Number] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.autoscaling.CfnWarmPool =
    software.amazon.awscdk.services.autoscaling.CfnWarmPool.Builder
      .create(stackCtx, internalResourceId)
      .autoScalingGroupName(autoScalingGroupName)
      .poolState(poolState.orNull)
      .maxGroupPreparedCapacity(maxGroupPreparedCapacity.orNull)
      .minSize(minSize.orNull)
      .build()
}
