package io.burkard.cdk.services.appmesh

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object HttpGatewayRoutePathMatchConfig {

  def apply(
    wholePathMatch: Option[software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpPathMatchProperty] = None,
    wholePathRewrite: Option[software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpGatewayRoutePathRewriteProperty] = None,
    prefixPathMatch: Option[String] = None,
    prefixPathRewrite: Option[software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpGatewayRoutePrefixRewriteProperty] = None
  ): software.amazon.awscdk.services.appmesh.HttpGatewayRoutePathMatchConfig =
    (new software.amazon.awscdk.services.appmesh.HttpGatewayRoutePathMatchConfig.Builder)
      .wholePathMatch(wholePathMatch.orNull)
      .wholePathRewrite(wholePathRewrite.orNull)
      .prefixPathMatch(prefixPathMatch.orNull)
      .prefixPathRewrite(prefixPathRewrite.orNull)
      .build()
}
