package io.burkard.cdk.services.apigateway

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ProxyResourceOptions {

  def apply(
    defaultCorsPreflightOptions: Option[software.amazon.awscdk.services.apigateway.CorsOptions] = None,
    defaultIntegration: Option[software.amazon.awscdk.services.apigateway.Integration] = None,
    defaultMethodOptions: Option[software.amazon.awscdk.services.apigateway.MethodOptions] = None,
    anyMethod: Option[Boolean] = None
  ): software.amazon.awscdk.services.apigateway.ProxyResourceOptions =
    (new software.amazon.awscdk.services.apigateway.ProxyResourceOptions.Builder)
      .defaultCorsPreflightOptions(defaultCorsPreflightOptions.orNull)
      .defaultIntegration(defaultIntegration.orNull)
      .defaultMethodOptions(defaultMethodOptions.orNull)
      .anyMethod(anyMethod.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
