package io.burkard.cdk.services.apigateway

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CognitoUserPoolsAuthorizer {

  def apply(
    internalResourceId: String,
    cognitoUserPools: List[_ <: software.amazon.awscdk.services.cognito.IUserPool],
    authorizerName: Option[String] = None,
    identitySource: Option[String] = None,
    resultsCacheTtl: Option[software.amazon.awscdk.Duration] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.apigateway.CognitoUserPoolsAuthorizer =
    software.amazon.awscdk.services.apigateway.CognitoUserPoolsAuthorizer.Builder
      .create(stackCtx, internalResourceId)
      .cognitoUserPools(cognitoUserPools.asJava)
      .authorizerName(authorizerName.orNull)
      .identitySource(identitySource.orNull)
      .resultsCacheTtl(resultsCacheTtl.orNull)
      .build()
}
