package io.burkard.cdk.cxapi

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object VpcSubnet {

  def apply(
    subnetId: String,
    availabilityZone: String,
    routeTableId: String,
    cidr: Option[String] = None
  ): software.amazon.awscdk.cxapi.VpcSubnet =
    (new software.amazon.awscdk.cxapi.VpcSubnet.Builder)
      .subnetId(subnetId)
      .availabilityZone(availabilityZone)
      .routeTableId(routeTableId)
      .cidr(cidr.orNull)
      .build()
}
