package io.burkard.cdk

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object RemovalPolicyOptions {

  def apply(
    defaultValue: Option[software.amazon.awscdk.RemovalPolicy] = None,
    applyToUpdateReplacePolicy: Option[Boolean] = None
  ): software.amazon.awscdk.RemovalPolicyOptions =
    (new software.amazon.awscdk.RemovalPolicyOptions.Builder)
      .defaultValue(defaultValue.orNull)
      .applyToUpdateReplacePolicy(applyToUpdateReplacePolicy.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
