package io.burkard.cdk.services.stepfunctions.tasks

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AthenaStartQueryExecution {

  def apply(
    internalResourceId: String,
    queryString: String,
    workGroup: Option[String] = None,
    resultPath: Option[String] = None,
    queryExecutionContext: Option[software.amazon.awscdk.services.stepfunctions.tasks.QueryExecutionContext] = None,
    resultConfiguration: Option[software.amazon.awscdk.services.stepfunctions.tasks.ResultConfiguration] = None,
    clientRequestToken: Option[String] = None,
    integrationPattern: Option[software.amazon.awscdk.services.stepfunctions.IntegrationPattern] = None,
    outputPath: Option[String] = None,
    comment: Option[String] = None,
    resultSelector: Option[Map[String, _]] = None,
    inputPath: Option[String] = None,
    timeout: Option[software.amazon.awscdk.Duration] = None,
    heartbeat: Option[software.amazon.awscdk.Duration] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.stepfunctions.tasks.AthenaStartQueryExecution =
    software.amazon.awscdk.services.stepfunctions.tasks.AthenaStartQueryExecution.Builder
      .create(stackCtx, internalResourceId)
      .queryString(queryString)
      .workGroup(workGroup.orNull)
      .resultPath(resultPath.orNull)
      .queryExecutionContext(queryExecutionContext.orNull)
      .resultConfiguration(resultConfiguration.orNull)
      .clientRequestToken(clientRequestToken.orNull)
      .integrationPattern(integrationPattern.orNull)
      .outputPath(outputPath.orNull)
      .comment(comment.orNull)
      .resultSelector(resultSelector.map(_.asJava).orNull)
      .inputPath(inputPath.orNull)
      .timeout(timeout.orNull)
      .heartbeat(heartbeat.orNull)
      .build()
}
