package io.burkard.cdk.services.servicecatalog

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnPortfolioProductAssociation {

  def apply(
    internalResourceId: String,
    productId: String,
    portfolioId: String,
    acceptLanguage: Option[String] = None,
    sourcePortfolioId: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.servicecatalog.CfnPortfolioProductAssociation =
    software.amazon.awscdk.services.servicecatalog.CfnPortfolioProductAssociation.Builder
      .create(stackCtx, internalResourceId)
      .productId(productId)
      .portfolioId(portfolioId)
      .acceptLanguage(acceptLanguage.orNull)
      .sourcePortfolioId(sourcePortfolioId.orNull)
      .build()
}
