package io.burkard.cdk.services.quicksight.cfnDataSource

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CredentialPairProperty {

  def apply(
    password: String,
    username: String,
    alternateDataSourceParameters: Option[List[_]] = None
  ): software.amazon.awscdk.services.quicksight.CfnDataSource.CredentialPairProperty =
    (new software.amazon.awscdk.services.quicksight.CfnDataSource.CredentialPairProperty.Builder)
      .password(password)
      .username(username)
      .alternateDataSourceParameters(alternateDataSourceParameters.map(_.asJava).orNull)
      .build()
}
