package io.burkard.cdk.services.opsworks

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnLayerProps {

  def apply(
    autoAssignElasticIps: Boolean,
    name: String,
    shortname: String,
    enableAutoHealing: Boolean,
    stackId: String,
    autoAssignPublicIps: Boolean,
    `type`: String,
    customSecurityGroupIds: Option[List[String]] = None,
    installUpdatesOnBoot: Option[Boolean] = None,
    loadBasedAutoScaling: Option[software.amazon.awscdk.services.opsworks.CfnLayer.LoadBasedAutoScalingProperty] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    customRecipes: Option[software.amazon.awscdk.services.opsworks.CfnLayer.RecipesProperty] = None,
    customInstanceProfileArn: Option[String] = None,
    volumeConfigurations: Option[List[_]] = None,
    attributes: Option[Map[String, String]] = None,
    customJson: Option[AnyRef] = None,
    useEbsOptimizedInstances: Option[Boolean] = None,
    lifecycleEventConfiguration: Option[software.amazon.awscdk.services.opsworks.CfnLayer.LifecycleEventConfigurationProperty] = None,
    packages: Option[List[String]] = None
  ): software.amazon.awscdk.services.opsworks.CfnLayerProps =
    (new software.amazon.awscdk.services.opsworks.CfnLayerProps.Builder)
      .autoAssignElasticIps(autoAssignElasticIps)
      .name(name)
      .shortname(shortname)
      .enableAutoHealing(enableAutoHealing)
      .stackId(stackId)
      .autoAssignPublicIps(autoAssignPublicIps)
      .`type`(`type`)
      .customSecurityGroupIds(customSecurityGroupIds.map(_.asJava).orNull)
      .installUpdatesOnBoot(installUpdatesOnBoot.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .loadBasedAutoScaling(loadBasedAutoScaling.orNull)
      .tags(tags.map(_.asJava).orNull)
      .customRecipes(customRecipes.orNull)
      .customInstanceProfileArn(customInstanceProfileArn.orNull)
      .volumeConfigurations(volumeConfigurations.map(_.asJava).orNull)
      .attributes(attributes.map(_.asJava).orNull)
      .customJson(customJson.orNull)
      .useEbsOptimizedInstances(useEbsOptimizedInstances.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .lifecycleEventConfiguration(lifecycleEventConfiguration.orNull)
      .packages(packages.map(_.asJava).orNull)
      .build()
}
