package io.burkard.cdk.services.opensearchservice.cfnDomain

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EBSOptionsProperty {

  def apply(
    ebsEnabled: Option[Boolean] = None,
    volumeSize: Option[Number] = None,
    volumeType: Option[String] = None,
    iops: Option[Number] = None
  ): software.amazon.awscdk.services.opensearchservice.CfnDomain.EBSOptionsProperty =
    (new software.amazon.awscdk.services.opensearchservice.CfnDomain.EBSOptionsProperty.Builder)
      .ebsEnabled(ebsEnabled.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .volumeSize(volumeSize.orNull)
      .volumeType(volumeType.orNull)
      .iops(iops.orNull)
      .build()
}
