package io.burkard.cdk.services.mediapackage.cfnPackagingConfiguration

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CmafPackageProperty {

  def apply(
    hlsManifests: List[_],
    includeEncoderConfigurationInSegments: Option[Boolean] = None,
    segmentDurationSeconds: Option[Number] = None,
    encryption: Option[software.amazon.awscdk.services.mediapackage.CfnPackagingConfiguration.CmafEncryptionProperty] = None
  ): software.amazon.awscdk.services.mediapackage.CfnPackagingConfiguration.CmafPackageProperty =
    (new software.amazon.awscdk.services.mediapackage.CfnPackagingConfiguration.CmafPackageProperty.Builder)
      .hlsManifests(hlsManifests.asJava)
      .includeEncoderConfigurationInSegments(includeEncoderConfigurationInSegments.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .segmentDurationSeconds(segmentDurationSeconds.orNull)
      .encryption(encryption.orNull)
      .build()
}
