package io.burkard.cdk.services.lex.cfnBotAlias

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object S3BucketLogDestinationProperty {

  def apply(
    s3BucketArn: String,
    logPrefix: String,
    kmsKeyArn: Option[String] = None
  ): software.amazon.awscdk.services.lex.CfnBotAlias.S3BucketLogDestinationProperty =
    (new software.amazon.awscdk.services.lex.CfnBotAlias.S3BucketLogDestinationProperty.Builder)
      .s3BucketArn(s3BucketArn)
      .logPrefix(logPrefix)
      .kmsKeyArn(kmsKeyArn.orNull)
      .build()
}
