package io.burkard.cdk.services.iotwireless.cfnMulticastGroup

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object LoRaWANProperty {

  def apply(
    dlClass: String,
    rfRegion: String,
    numberOfDevicesInGroup: Option[Number] = None,
    numberOfDevicesRequested: Option[Number] = None
  ): software.amazon.awscdk.services.iotwireless.CfnMulticastGroup.LoRaWANProperty =
    (new software.amazon.awscdk.services.iotwireless.CfnMulticastGroup.LoRaWANProperty.Builder)
      .dlClass(dlClass)
      .rfRegion(rfRegion)
      .numberOfDevicesInGroup(numberOfDevicesInGroup.orNull)
      .numberOfDevicesRequested(numberOfDevicesRequested.orNull)
      .build()
}
