package io.burkard.cdk.services.ec2

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnIPAMProps {

  def apply(
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    description: Option[String] = None,
    operatingRegions: Option[List[_]] = None
  ): software.amazon.awscdk.services.ec2.CfnIPAMProps =
    (new software.amazon.awscdk.services.ec2.CfnIPAMProps.Builder)
      .tags(tags.map(_.asJava).orNull)
      .description(description.orNull)
      .operatingRegions(operatingRegions.map(_.asJava).orNull)
      .build()
}
