package io.burkard.cdk.services.codedeploy.cfnDeploymentGroup

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AlarmConfigurationProperty {

  def apply(
    enabled: Option[Boolean] = None,
    alarms: Option[List[_]] = None,
    ignorePollAlarmFailure: Option[Boolean] = None
  ): software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.AlarmConfigurationProperty =
    (new software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.AlarmConfigurationProperty.Builder)
      .enabled(enabled.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .alarms(alarms.map(_.asJava).orNull)
      .ignorePollAlarmFailure(ignorePollAlarmFailure.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
