package io.burkard.cdk.services.pinpoint

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnBaiduChannelProps {

  def apply(
    secretKey: String,
    apiKey: String,
    applicationId: String,
    enabled: Option[Boolean] = None
  ): software.amazon.awscdk.services.pinpoint.CfnBaiduChannelProps =
    (new software.amazon.awscdk.services.pinpoint.CfnBaiduChannelProps.Builder)
      .secretKey(secretKey)
      .apiKey(apiKey)
      .applicationId(applicationId)
      .enabled(enabled.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
