package io.burkard.cdk.services.opsworks

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnUserProfileProps {

  def apply(
    iamUserArn: String,
    allowSelfManagement: Option[Boolean] = None,
    sshPublicKey: Option[String] = None,
    sshUsername: Option[String] = None
  ): software.amazon.awscdk.services.opsworks.CfnUserProfileProps =
    (new software.amazon.awscdk.services.opsworks.CfnUserProfileProps.Builder)
      .iamUserArn(iamUserArn)
      .allowSelfManagement(allowSelfManagement.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .sshPublicKey(sshPublicKey.orNull)
      .sshUsername(sshUsername.orNull)
      .build()
}
