package io.burkard.cdk.services.nimblestudio.cfnLaunchProfile

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object StreamConfigurationProperty {

  def apply(
    streamingImageIds: List[String],
    clipboardMode: String,
    ec2InstanceTypes: List[String],
    maxSessionLengthInMinutes: Option[Number] = None
  ): software.amazon.awscdk.services.nimblestudio.CfnLaunchProfile.StreamConfigurationProperty =
    (new software.amazon.awscdk.services.nimblestudio.CfnLaunchProfile.StreamConfigurationProperty.Builder)
      .streamingImageIds(streamingImageIds.asJava)
      .clipboardMode(clipboardMode)
      .ec2InstanceTypes(ec2InstanceTypes.asJava)
      .maxSessionLengthInMinutes(maxSessionLengthInMinutes.orNull)
      .build()
}
