package io.burkard.cdk.services.location

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnMap {

  def apply(
    internalResourceId: String,
    configuration: software.amazon.awscdk.services.location.CfnMap.MapConfigurationProperty,
    pricingPlan: String,
    mapName: String,
    description: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.location.CfnMap =
    software.amazon.awscdk.services.location.CfnMap.Builder
      .create(stackCtx, internalResourceId)
      .configuration(configuration)
      .pricingPlan(pricingPlan)
      .mapName(mapName)
      .description(description.orNull)
      .build()
}
