package io.burkard.cdk.services.inspector

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnAssessmentTarget {

  def apply(
    internalResourceId: String,
    assessmentTargetName: Option[String] = None,
    resourceGroupArn: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.inspector.CfnAssessmentTarget =
    software.amazon.awscdk.services.inspector.CfnAssessmentTarget.Builder
      .create(stackCtx, internalResourceId)
      .assessmentTargetName(assessmentTargetName.orNull)
      .resourceGroupArn(resourceGroupArn.orNull)
      .build()
}
