package io.burkard.cdk.services.iam

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnAccessKey {

  def apply(
    internalResourceId: String,
    userName: String,
    status: Option[String] = None,
    serial: Option[Number] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.iam.CfnAccessKey =
    software.amazon.awscdk.services.iam.CfnAccessKey.Builder
      .create(stackCtx, internalResourceId)
      .userName(userName)
      .status(status.orNull)
      .serial(serial.orNull)
      .build()
}
