package io.burkard.cdk.services.glue

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnMLTransform {

  def apply(
    internalResourceId: String,
    role: String,
    inputRecordTables: software.amazon.awscdk.services.glue.CfnMLTransform.InputRecordTablesProperty,
    transformParameters: software.amazon.awscdk.services.glue.CfnMLTransform.TransformParametersProperty,
    transformEncryption: Option[software.amazon.awscdk.services.glue.CfnMLTransform.TransformEncryptionProperty] = None,
    name: Option[String] = None,
    maxCapacity: Option[Number] = None,
    numberOfWorkers: Option[Number] = None,
    description: Option[String] = None,
    tags: Option[AnyRef] = None,
    workerType: Option[String] = None,
    maxRetries: Option[Number] = None,
    timeout: Option[Number] = None,
    glueVersion: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.glue.CfnMLTransform =
    software.amazon.awscdk.services.glue.CfnMLTransform.Builder
      .create(stackCtx, internalResourceId)
      .role(role)
      .inputRecordTables(inputRecordTables)
      .transformParameters(transformParameters)
      .transformEncryption(transformEncryption.orNull)
      .name(name.orNull)
      .maxCapacity(maxCapacity.orNull)
      .numberOfWorkers(numberOfWorkers.orNull)
      .description(description.orNull)
      .tags(tags.orNull)
      .workerType(workerType.orNull)
      .maxRetries(maxRetries.orNull)
      .timeout(timeout.orNull)
      .glueVersion(glueVersion.orNull)
      .build()
}
