package io.burkard.cdk.services.events.targets

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object LambdaFunctionProps {

  def apply(
    event: Option[software.amazon.awscdk.services.events.RuleTargetInput] = None,
    retryAttempts: Option[Number] = None,
    deadLetterQueue: Option[software.amazon.awscdk.services.sqs.IQueue] = None,
    maxEventAge: Option[software.amazon.awscdk.Duration] = None
  ): software.amazon.awscdk.services.events.targets.LambdaFunctionProps =
    (new software.amazon.awscdk.services.events.targets.LambdaFunctionProps.Builder)
      .event(event.orNull)
      .retryAttempts(retryAttempts.orNull)
      .deadLetterQueue(deadLetterQueue.orNull)
      .maxEventAge(maxEventAge.orNull)
      .build()
}
