package io.burkard.cdk.services.emr.cfnCluster

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object InstanceTypeConfigProperty {

  def apply(
    instanceType: String,
    ebsConfiguration: Option[software.amazon.awscdk.services.emr.CfnCluster.EbsConfigurationProperty] = None,
    customAmiId: Option[String] = None,
    bidPrice: Option[String] = None,
    bidPriceAsPercentageOfOnDemandPrice: Option[Number] = None,
    weightedCapacity: Option[Number] = None,
    configurations: Option[List[_]] = None
  ): software.amazon.awscdk.services.emr.CfnCluster.InstanceTypeConfigProperty =
    (new software.amazon.awscdk.services.emr.CfnCluster.InstanceTypeConfigProperty.Builder)
      .instanceType(instanceType)
      .ebsConfiguration(ebsConfiguration.orNull)
      .customAmiId(customAmiId.orNull)
      .bidPrice(bidPrice.orNull)
      .bidPriceAsPercentageOfOnDemandPrice(bidPriceAsPercentageOfOnDemandPrice.orNull)
      .weightedCapacity(weightedCapacity.orNull)
      .configurations(configurations.map(_.asJava).orNull)
      .build()
}
