package io.burkard.cdk.services.eks

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object KubectlProviderAttributes {

  def apply(
    functionArn: String,
    handlerRole: software.amazon.awscdk.services.iam.IRole,
    kubectlRoleArn: String
  ): software.amazon.awscdk.services.eks.KubectlProviderAttributes =
    (new software.amazon.awscdk.services.eks.KubectlProviderAttributes.Builder)
      .functionArn(functionArn)
      .handlerRole(handlerRole)
      .kubectlRoleArn(kubectlRoleArn)
      .build()
}
