package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnNetworkInterfaceAttachment {

  def apply(
    internalResourceId: String,
    networkInterfaceId: String,
    instanceId: String,
    deviceIndex: String,
    deleteOnTermination: Option[Boolean] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ec2.CfnNetworkInterfaceAttachment =
    software.amazon.awscdk.services.ec2.CfnNetworkInterfaceAttachment.Builder
      .create(stackCtx, internalResourceId)
      .networkInterfaceId(networkInterfaceId)
      .instanceId(instanceId)
      .deviceIndex(deviceIndex)
      .deleteOnTermination(deleteOnTermination.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
