package io.burkard.cdk.services.ec2

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnIPAMScope {

  def apply(
    internalResourceId: String,
    ipamId: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    description: Option[String] = None,
    ipamScopeType: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ec2.CfnIPAMScope =
    software.amazon.awscdk.services.ec2.CfnIPAMScope.Builder
      .create(stackCtx, internalResourceId)
      .ipamId(ipamId)
      .tags(tags.map(_.asJava).orNull)
      .description(description.orNull)
      .ipamScopeType(ipamScopeType.orNull)
      .build()
}
