package io.burkard.cdk.services.ec2

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnFlowLog {

  def apply(
    internalResourceId: String,
    resourceId: String,
    resourceType: String,
    trafficType: String,
    maxAggregationInterval: Option[Number] = None,
    logDestinationType: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    deliverLogsPermissionArn: Option[String] = None,
    logGroupName: Option[String] = None,
    logFormat: Option[String] = None,
    logDestination: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ec2.CfnFlowLog =
    software.amazon.awscdk.services.ec2.CfnFlowLog.Builder
      .create(stackCtx, internalResourceId)
      .resourceId(resourceId)
      .resourceType(resourceType)
      .trafficType(trafficType)
      .maxAggregationInterval(maxAggregationInterval.orNull)
      .logDestinationType(logDestinationType.orNull)
      .tags(tags.map(_.asJava).orNull)
      .deliverLogsPermissionArn(deliverLogsPermissionArn.orNull)
      .logGroupName(logGroupName.orNull)
      .logFormat(logFormat.orNull)
      .logDestination(logDestination.orNull)
      .build()
}
