package io.burkard.cdk.services.datasync

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnLocationFSxWindows {

  def apply(
    internalResourceId: String,
    securityGroupArns: List[String],
    fsxFilesystemArn: String,
    user: String,
    password: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    domain: Option[String] = None,
    subdirectory: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.datasync.CfnLocationFSxWindows =
    software.amazon.awscdk.services.datasync.CfnLocationFSxWindows.Builder
      .create(stackCtx, internalResourceId)
      .securityGroupArns(securityGroupArns.asJava)
      .fsxFilesystemArn(fsxFilesystemArn)
      .user(user)
      .password(password)
      .tags(tags.map(_.asJava).orNull)
      .domain(domain.orNull)
      .subdirectory(subdirectory.orNull)
      .build()
}
