package io.burkard.cdk.services.cognito

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object OAuthFlows {

  def apply(
    clientCredentials: Option[Boolean] = None,
    authorizationCodeGrant: Option[Boolean] = None,
    implicitCodeGrant: Option[Boolean] = None
  ): software.amazon.awscdk.services.cognito.OAuthFlows =
    (new software.amazon.awscdk.services.cognito.OAuthFlows.Builder)
      .clientCredentials(clientCredentials.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .authorizationCodeGrant(authorizationCodeGrant.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .implicitCodeGrant(implicitCodeGrant.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
