package io.burkard.cdk.services.backup

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object BackupPlan {

  def apply(
    internalResourceId: String,
    backupPlanRules: Option[List[_ <: software.amazon.awscdk.services.backup.BackupPlanRule]] = None,
    windowsVss: Option[Boolean] = None,
    backupPlanName: Option[String] = None,
    backupVault: Option[software.amazon.awscdk.services.backup.IBackupVault] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.backup.BackupPlan =
    software.amazon.awscdk.services.backup.BackupPlan.Builder
      .create(stackCtx, internalResourceId)
      .backupPlanRules(backupPlanRules.map(_.asJava).orNull)
      .windowsVss(windowsVss.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .backupPlanName(backupPlanName.orNull)
      .backupVault(backupVault.orNull)
      .build()
}
