package io.burkard.cdk.services.apprunner.cfnService

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SourceConfigurationProperty {

  def apply(
    authenticationConfiguration: Option[software.amazon.awscdk.services.apprunner.CfnService.AuthenticationConfigurationProperty] = None,
    codeRepository: Option[software.amazon.awscdk.services.apprunner.CfnService.CodeRepositoryProperty] = None,
    autoDeploymentsEnabled: Option[Boolean] = None,
    imageRepository: Option[software.amazon.awscdk.services.apprunner.CfnService.ImageRepositoryProperty] = None
  ): software.amazon.awscdk.services.apprunner.CfnService.SourceConfigurationProperty =
    (new software.amazon.awscdk.services.apprunner.CfnService.SourceConfigurationProperty.Builder)
      .authenticationConfiguration(authenticationConfiguration.orNull)
      .codeRepository(codeRepository.orNull)
      .autoDeploymentsEnabled(autoDeploymentsEnabled.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .imageRepository(imageRepository.orNull)
      .build()
}
