package io.burkard.cdk.services.appmesh.cfnRoute

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object HttpRetryPolicyProperty {

  def apply(
    maxRetries: Number,
    perRetryTimeout: software.amazon.awscdk.services.appmesh.CfnRoute.DurationProperty,
    httpRetryEvents: Option[List[String]] = None,
    tcpRetryEvents: Option[List[String]] = None
  ): software.amazon.awscdk.services.appmesh.CfnRoute.HttpRetryPolicyProperty =
    (new software.amazon.awscdk.services.appmesh.CfnRoute.HttpRetryPolicyProperty.Builder)
      .maxRetries(maxRetries)
      .perRetryTimeout(perRetryTimeout)
      .httpRetryEvents(httpRetryEvents.map(_.asJava).orNull)
      .tcpRetryEvents(tcpRetryEvents.map(_.asJava).orNull)
      .build()
}
