package io.burkard.cdk.services.apigateway

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object MethodProps {

  def apply(
    resource: software.amazon.awscdk.services.apigateway.IResource,
    httpMethod: String,
    options: Option[software.amazon.awscdk.services.apigateway.MethodOptions] = None,
    integration: Option[software.amazon.awscdk.services.apigateway.Integration] = None
  ): software.amazon.awscdk.services.apigateway.MethodProps =
    (new software.amazon.awscdk.services.apigateway.MethodProps.Builder)
      .resource(resource)
      .httpMethod(httpMethod)
      .options(options.orNull)
      .integration(integration.orNull)
      .build()
}
