package io.burkard.cdk.services.apigateway

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnVpcLink {

  def apply(
    internalResourceId: String,
    name: String,
    targetArns: List[String],
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    description: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.apigateway.CfnVpcLink =
    software.amazon.awscdk.services.apigateway.CfnVpcLink.Builder
      .create(stackCtx, internalResourceId)
      .name(name)
      .targetArns(targetArns.asJava)
      .tags(tags.map(_.asJava).orNull)
      .description(description.orNull)
      .build()
}
