package io.burkard.cdk.services.ses.actions

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object S3Props {

  def apply(
    bucket: software.amazon.awscdk.services.s3.IBucket,
    objectKeyPrefix: Option[String] = None,
    topic: Option[software.amazon.awscdk.services.sns.ITopic] = None,
    kmsKey: Option[software.amazon.awscdk.services.kms.IKey] = None
  ): software.amazon.awscdk.services.ses.actions.S3Props =
    (new software.amazon.awscdk.services.ses.actions.S3Props.Builder)
      .bucket(bucket)
      .objectKeyPrefix(objectKeyPrefix.orNull)
      .topic(topic.orNull)
      .kmsKey(kmsKey.orNull)
      .build()
}
