package io.burkard.cdk.services.refactorspaces.cfnRoute

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object UriPathRouteInputProperty {

  def apply(
    activationState: String,
    methods: Option[List[String]] = None,
    includeChildPaths: Option[Boolean] = None,
    sourcePath: Option[String] = None
  ): software.amazon.awscdk.services.refactorspaces.CfnRoute.UriPathRouteInputProperty =
    (new software.amazon.awscdk.services.refactorspaces.CfnRoute.UriPathRouteInputProperty.Builder)
      .activationState(activationState)
      .methods(methods.map(_.asJava).orNull)
      .includeChildPaths(includeChildPaths.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .sourcePath(sourcePath.orNull)
      .build()
}
