package io.burkard.cdk.services.lex.cfnBot

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object S3LocationProperty {

  def apply(
    s3ObjectKey: String,
    s3Bucket: String,
    s3ObjectVersion: Option[String] = None
  ): software.amazon.awscdk.services.lex.CfnBot.S3LocationProperty =
    (new software.amazon.awscdk.services.lex.CfnBot.S3LocationProperty.Builder)
      .s3ObjectKey(s3ObjectKey)
      .s3Bucket(s3Bucket)
      .s3ObjectVersion(s3ObjectVersion.orNull)
      .build()
}
